
/**
 * BankAccount class
 */
public class BankAccount {

    Customer customer;
    long accountNumber;
    double balance;

    // COnstructor
    public BankAccount(String firstName, String lastName, String SSN, double balance) {
        customer = new Customer(firstName, lastName, SSN);
        this.balance = balance;
        accountNumber = (long) Math.floor(Math.random() * 9_000_000_000L) + 1_000_000_000L;
        System.out.println(
                "Successfully created account for " + firstName + " " + lastName + " Account Number " + accountNumber);
        checkBalance();
    }

    // deposits the amount into the account
    public void deposit(double amount) {
        balance = balance + amount;
        System.out.println(customer.getFirstName() + " " + customer.getLastName() + " deposited $" + amount
                + ". Current Balance $" + balance);
    }

    // withdraws the amount from account
    public void withdraw(double amount) {
        if (balance >= amount) {
            balance = balance - amount;
            System.out.println(customer.getFirstName() + " " + customer.getLastName() + " withdrew $" + amount
                    + ". Current Balance $" + balance);
        } else {
            System.out.println("Unable to withdraw " + amount + " for " + customer.getFirstName() + " "
                    + customer.getLastName() + " due to insufficient funds.");
        }
    }

    // display the balance of the account
    public void checkBalance() {
        System.out.println(customer.getFirstName() + " " + customer.getLastName() + ", Balance $" + balance);
    }
}
